/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ThumbnailCreator {
    private static String[] IMAGE_FORMAT = new String[]{"jpeg", "png", "bmp", "wbmp", "gif"};
    private int outputImageFormatIndex = -1;
    private int thumbWidth = 150;
    private int thumbHeight = 150;
    private URL url = null;
    private String outputFileName = null;
    private File outputFile = null;
    private int orginalImageWidth = 0;
    private int orginalImageHeight = 0;

    public void setOutputFileName(String string) {
        this.outputFileName = string;
        this.outputFile = new File(this.outputFileName);
    }

    public void setURL(String string) {
        string = string.replaceAll("\\s", "%20");
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.print(malformedURLException);
            System.exit(2);
        }
    }

    public void setSize(String string, String string2) {
        this.thumbWidth = Integer.parseInt(string);
        this.thumbHeight = Integer.parseInt(string2);
    }

    public void setSize(int n, int n2) {
        this.thumbWidth = n;
        this.thumbHeight = n2;
    }

    public void initFormat(String string) {
        this.outputImageFormatIndex = -1;
        for (int i = 0; i < IMAGE_FORMAT.length; ++i) {
            if (string.trim().compareToIgnoreCase(IMAGE_FORMAT[i]) != 0) continue;
            this.outputImageFormatIndex = i;
            break;
        }
        if (this.outputImageFormatIndex == -1) {
            System.err.println("invalid image format: " + string);
            System.exit(3);
        }
    }

    public String getOrginalImageSize() {
        return Integer.toString(this.orginalImageWidth) + " x " + Integer.toString(this.orginalImageHeight);
    }

    private void test() {
        this.setURL("http://www.tropicallichens.net/showphoto.aspx?q=fullimage&id=3169&speciesname=Acantholichen pannarioides");
        this.setURL("http://www.nhm.uio.no/botanisk/lav/Photo_Gallery/Acarospora/awdawda-habitat_G=awdawdawd_C=unknown_I=3F.jpg");
        this.setSize("180", "200");
        this.initFormat("png");
        this.setOutputFileName("/home/didi/output.png");
        this.build();
    }

    public boolean build() {
        try {
            boolean bl = false;
            if (bl && this.outputFile.exists()) {
                System.out.println("Thumbnail exists for URL: " + this.url + " ... skip");
                return false;
            }
            BufferedImage bufferedImage = null;
            bufferedImage = ImageIO.read(this.url);
            BufferedImage bufferedImage2 = null;
            this.orginalImageWidth = bufferedImage.getWidth();
            this.orginalImageHeight = bufferedImage.getHeight();
            double d = (double)this.orginalImageWidth / (double)this.thumbWidth;
            double d2 = (double)this.orginalImageHeight / (double)this.thumbHeight;
            double d3 = Math.max(d, d2);
            this.thumbWidth = (int)((double)this.orginalImageWidth / d3);
            this.thumbHeight = (int)((double)this.orginalImageHeight / d3);
            Graphics2D graphics2D = null;
            bufferedImage2 = new BufferedImage(this.thumbWidth, this.thumbHeight, 1);
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            boolean bl2 = graphics2D.drawImage(bufferedImage, 0, 0, this.thumbWidth, this.thumbHeight, null);
            ImageIO.write((RenderedImage)bufferedImage2, IMAGE_FORMAT[this.outputImageFormatIndex], this.outputFile);
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger(ThumbnailCreator.class.getName()).log(Level.SEVERE, null, nullPointerException);
            return false;
        }
        catch (IOException iOException) {
            Logger.getLogger(ThumbnailCreator.class.getName()).log(Level.SEVERE, null, iOException);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        ThumbnailCreator thumbnailCreator = new ThumbnailCreator();
        if (stringArray.length == 2) {
            thumbnailCreator.setURL(stringArray[0]);
            thumbnailCreator.setOutputFileName(stringArray[1]);
        } else if (stringArray.length == 4) {
            thumbnailCreator.setURL(stringArray[0]);
            thumbnailCreator.setOutputFileName(stringArray[1]);
            thumbnailCreator.setSize(stringArray[2], stringArray[3]);
        }
        if (stringArray.length == 5) {
            thumbnailCreator.initFormat(stringArray[4]);
        } else {
            System.out.println("ThumbnailCreator ImageURL outputFile [ThumbnailWidth ThumbnailHeight] { jpeg | png | bmp | wbmp | gif }");
        }
        thumbnailCreator.test();
    }
}

