/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MergeTimageFiles {
    TreeMap<String, List> timagedata = null;

    private MergeTimageFiles() {
        this.init();
    }

    private final void init() {
        this.timagedata = new TreeMap();
    }

    private void add(String string, String string2) {
        if (string == null || string2 == null) {
            System.err.println("Invalid data.");
            return;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return;
        }
        if (this.timagedata.containsKey(string)) {
            this.timagedata.get(string).add(string2);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            this.timagedata.put(string, linkedList);
        }
    }

    private void test() {
        this.add("A", "1");
        this.add("B", "1");
        this.add("C", "1");
        this.add("A", "2");
        this.add("A", "3");
        this.add("B", "2");
    }

    private void print() {
        for (String string : this.timagedata.keySet()) {
            System.out.println(string);
            Iterator iterator = this.timagedata.get(string).iterator();
            while (iterator.hasNext()) {
                System.out.println("    " + iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            String string3 = null;
            while (bufferedReader.ready()) {
                string3 = bufferedReader.readLine();
                if (string3.startsWith("#")) {
                    string2 = this.removeFormatAndComment(string3);
                    int n = string2.indexOf(95);
                    if (n <= 2) continue;
                    string2 = string2.substring(0, n) + "/";
                    continue;
                }
                this.add(string2, string3);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(MergeTimageFiles.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(MergeTimageFiles.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(MergeTimageFiles.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private String removeFormatAndComment(String string) {
        string = string.replaceAll("<.*>", "");
        string = string.replaceAll("\\\\i\\{\\}", "");
        string = string.replaceAll("\\\\i0\\{\\}", "");
        string = string.replaceAll("\\\\b\\{\\}", "");
        string = string.replaceAll("\\\\b0\\{\\}", "");
        string = string.replaceAll("\\\\lquote\\{\\}", "'");
        string = string.replaceAll("\\\\rquote\\{\\}", "'");
        string = string.replaceAll("\\\\sub\\{\\}", "");
        string = string.replaceAll("\\\\nosupersub\\{\\}", "");
        return string;
    }

    public static void main(String[] stringArray) {
        MergeTimageFiles mergeTimageFiles = new MergeTimageFiles();
        if (stringArray.length < 2) {
            System.out.println("usage:");
            System.out.println("MergeTimageFiles file [[file]...]");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_Iceland.txt");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_Italic.txt");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_LIASLight_Oslo-new.txt");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_LIASLight_UK_070801.txt");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_TropicLichens.txt");
            mergeTimageFiles.addFile("/home/didi/NetBeans-6-0-Projects/DiversityNavigator/timages_www_stridvall_se.txt");
            mergeTimageFiles.print();
            System.exit(1);
        }
        for (int i = 1; i < stringArray.length; ++i) {
            System.out.println("Merge file: " + stringArray[i]);
            mergeTimageFiles.addFile(stringArray[i]);
        }
        mergeTimageFiles.print();
        System.exit(1);
    }
}

