/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.metadiversity.diversity.navikey.bo.BasicItemCharacter;
import net.metadiversity.diversity.navikey.bo.BasicState;
import net.metadiversity.diversity.navikey.bo.DeltaInterface;
import net.metadiversity.diversity.navikey.delta.TImageFileReader;
import net.metadiversity.diversity.navikey.ui.ItemCharacterPanel;
import net.metadiversity.diversity.navikey.ui.ItemStatePanel;
import net.metadiversity.diversity.navikey.ui.ItemsPanel;
import net.metadiversity.diversity.navikey.ui.MultiStatePanel;
import net.metadiversity.diversity.navikey.ui.MyItemPanel;
import net.metadiversity.diversity.navikey.ui.NaviKey;
import net.metadiversity.diversity.navikey.ui.NumericStatePanel;
import net.metadiversity.diversity.navikey.ui.ResultItemStateFrame;
import net.metadiversity.diversity.navikey.ui.StatePanel;

class SuperPanel
extends JPanel {
    private static final long serialVersionUID = 3256719576480758066L;
    ItemCharacterPanel itemCharacterPanel;
    MultiStatePanel multiStatePanel;
    NumericStatePanel numericStatePanel;
    ItemsPanel itemsPanel;
    MyItemPanel myItemPanel;
    StatePanel statePanel;
    DeltaInterface delta;
    NaviKey navikey;
    private String numericStatePanelAction = "NumericStatePanelAction";
    private String myItemPanelAction = "MyItemPanelAction";
    private String multiStatePanelAction = "MultiStatePanelAction";
    private Vector<Integer> multiStatePanelSelectedIds = new Vector();
    private int panelSizeX = 300;
    private int panelSizeY = 250;
    private boolean debug = false;

    public SuperPanel(NaviKey naviKey, DeltaInterface deltaInterface) {
        this.delta = deltaInterface;
        this.navikey = naviKey;
        this.setBackground(NaviKey.naviKeyBackgroundColor);
        this.setForeground(NaviKey.buttonColor);
        this.setLayout(new GridLayout(2, 2));
        this.itemCharacterPanel = new ItemCharacterPanel();
        this.statePanel = new StatePanel();
        this.multiStatePanel = new MultiStatePanel();
        this.numericStatePanel = new NumericStatePanel();
        this.myItemPanel = new MyItemPanel(deltaInterface);
        this.itemsPanel = new ItemsPanel(naviKey);
        this.multiStatePanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SuperPanel.this.multiStatePanelChange(listSelectionEvent);
            }
        });
        this.itemCharacterPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SuperPanel.this.itemCharacterPanelChange(listSelectionEvent);
            }
        });
        this.itemsPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SuperPanel.this.itemsPanelSelection(listSelectionEvent);
            }
        });
        GuiAction guiAction = new GuiAction(naviKey, this.numericStatePanelAction);
        this.numericStatePanel.addNavikeyGuiListener(guiAction);
        guiAction = new GuiAction(naviKey, this.myItemPanelAction);
        this.myItemPanel.addNavikeyGuiListener(guiAction);
        guiAction = new GuiAction(naviKey, this.multiStatePanelAction);
        this.multiStatePanel.addNavikeyGuiListener(guiAction);
        this.itemCharacterPanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
        this.statePanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
        this.multiStatePanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
        this.numericStatePanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
        this.myItemPanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
        this.itemsPanel.setSize(new Dimension(this.panelSizeX, this.panelSizeX));
    }

    public AbstractAction getNavikeyGuiListener(String string) {
        return new GuiAction(this.navikey, string);
    }

    public void myItemPanelRemoveReset(ActionEvent actionEvent) {
        if (this.debug) {
            System.out.println("SuperPanel: myItemPanelRemoveReset" + actionEvent);
        }
        this.myItemPanel.updateList();
        this.itemsPanel.setItems(this.delta.getItemList(this.myItemPanel.getStates()));
        this.itemsPanel.updateList();
        if (this.navikey.isIntelligence()) {
            this.itemCharacterPanel.setItemCharacters(this.delta.getItemCharacterList(this.myItemPanel.getStates(), this.navikey.isIntelligence(), this.navikey.isDependencies()));
            this.itemCharacterPanel.updateList();
        }
        this.blankOutStatePanel();
        this.repaint();
    }

    public void itemCharacterPanelChange(ListSelectionEvent listSelectionEvent) {
        int n;
        if (this.debug) {
            System.out.println("SuperPanel: itemCharacterPanelChange(): " + listSelectionEvent);
        }
        if (!listSelectionEvent.getValueIsAdjusting() && (n = ((JList)listSelectionEvent.getSource()).getSelectedIndex()) >= 0) {
            this.itemCharacterSelection(n);
        }
    }

    public void multiStatePanelChange(ListSelectionEvent listSelectionEvent) {
        if (this.debug) {
            System.out.println("SuperPanel: multiStatePanelChange" + listSelectionEvent);
        }
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            boolean bl = listSelectionEvent.getValueIsAdjusting();
            System.out.print("Event for indexes " + n + " - " + n2 + "; isAdjusting is " + bl + "; selected indexes:");
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList.isSelectionEmpty()) {
                System.out.print(" <none>");
            } else {
                this.multiStatePanelSelectedIds.clear();
                int n3 = jList.getMinSelectionIndex();
                int n4 = jList.getMaxSelectionIndex();
                for (int i = n3; i <= n4; ++i) {
                    if (!jList.isSelectedIndex(i)) continue;
                    this.multiStatePanelSelectedIds.add(new Integer(i));
                }
            }
        }
    }

    public void itemsPanelSelection(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
        if (n >= 0) {
            Integer n2 = this.itemsPanel.getItem(n).getId();
            String string = this.delta.getItemTitle(n2);
            Vector<String> vector = this.delta.getItemDescription(n2);
            Vector vector2 = this.delta.getItemResources(n2);
            if (this.navikey.isUseTabSheetsFlag()) {
                string = TImageFileReader.removeFormatAndComment(string);
                String string2 = this.delta.getItemImage(string);
                System.out.println("Item: " + string + " Image: " + string2);
                this.navikey.showResult(string, new ItemStatePanel(vector, vector2), string2);
            } else {
                new ResultItemStateFrame(string, vector, vector2);
            }
        }
        ((JList)listSelectionEvent.getSource()).clearSelection();
    }

    public void build() {
        this.statePanel.add("multi", this.multiStatePanel);
        this.statePanel.add("numeric", this.numericStatePanel);
        LayoutManager layoutManager = this.statePanel.getLayout();
        this.add(this.itemCharacterPanel);
        this.add(this.statePanel);
        this.add(this.myItemPanel);
        this.add(this.itemsPanel);
        if (layoutManager instanceof CardLayout) {
            CardLayout cardLayout = (CardLayout)this.statePanel.getLayout();
            cardLayout.show(this.statePanel, "numeric");
        }
        this.setVisible(true);
    }

    public void itemCharacterSelection(int n) {
        if (n < 0) {
            return;
        }
        BasicItemCharacter basicItemCharacter = this.itemCharacterPanel.getItemCharacter(n);
        if (basicItemCharacter.isMultiState()) {
            this.multiStatePanel.setStates(this.delta.getStateList(this.myItemPanel.getStates(), basicItemCharacter.getId(), this.navikey.isIntelligence()));
            this.multiStatePanel.updateList();
            ((CardLayout)this.statePanel.getLayout()).first(this.statePanel);
            this.repaint();
        } else if (basicItemCharacter.isNumeric()) {
            if (this.navikey.isShowLiasUnitsFlag()) {
                this.numericStatePanel.setText(basicItemCharacter.getName());
            }
            ((CardLayout)this.statePanel.getLayout()).last(this.statePanel);
            this.repaint();
        } else {
            System.out.println("I hope this is text.");
        }
    }

    private void blankOutStatePanel() {
        this.numericStatePanel.reset();
        this.multiStatePanel.setStates(new Vector<BasicState>());
        this.multiStatePanel.updateList();
        ((CardLayout)this.statePanel.getLayout()).first(this.statePanel);
        this.itemCharacterPanel.getTheList().clearSelection();
    }

    private class GuiAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257001068687863860L;

        public GuiAction(NaviKey naviKey, String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.getValue("Name");
            System.out.println("GuiAction: " + string + " [" + actionEvent.getActionCommand() + "]");
            if (string.compareTo("Options") == 0 && actionEvent.getActionCommand().compareTo("OptionsChanged") == 0) {
                SuperPanel.this.myItemPanel.updateList();
                SuperPanel.this.itemsPanel.setItems(SuperPanel.this.delta.getItemList(SuperPanel.this.myItemPanel.getStates()));
                SuperPanel.this.itemsPanel.updateList();
                SuperPanel.this.itemCharacterPanel.setItemCharacters(SuperPanel.this.delta.getItemCharacterList(SuperPanel.this.myItemPanel.getStates(), SuperPanel.this.navikey.isIntelligence(), SuperPanel.this.navikey.isDependencies()));
                SuperPanel.this.itemCharacterPanel.updateList();
                SuperPanel.this.repaint();
            }
            if (string.compareTo(SuperPanel.this.numericStatePanelAction) == 0 && actionEvent.getActionCommand().compareTo("Set numeric state") == 0) {
                BasicState basicState = SuperPanel.this.numericStatePanel.getState();
                basicState.setCharacterId(SuperPanel.this.itemCharacterPanel.getItemCharacter().getId());
                SuperPanel.this.myItemPanel.addState(basicState);
                SuperPanel.this.myItemPanel.updateList();
                SuperPanel.this.itemsPanel.setItems(SuperPanel.this.delta.getItemList(SuperPanel.this.myItemPanel.getStates()));
                SuperPanel.this.itemsPanel.updateList();
                if (SuperPanel.this.navikey.isIntelligence()) {
                    SuperPanel.this.itemCharacterPanel.setItemCharacters(SuperPanel.this.delta.getItemCharacterList(SuperPanel.this.myItemPanel.getStates(), SuperPanel.this.navikey.isIntelligence(), SuperPanel.this.navikey.isDependencies()));
                    SuperPanel.this.itemCharacterPanel.updateList();
                }
                SuperPanel.this.blankOutStatePanel();
                SuperPanel.this.repaint();
            }
            if (string.compareTo(SuperPanel.this.myItemPanelAction) == 0) {
                SuperPanel.this.myItemPanelRemoveReset(actionEvent);
                SuperPanel.this.repaint();
            }
            if (string.compareTo(SuperPanel.this.multiStatePanelAction) == 0) {
                for (int i = 0; i < SuperPanel.this.multiStatePanelSelectedIds.size(); ++i) {
                    int n = (Integer)SuperPanel.this.multiStatePanelSelectedIds.get(i);
                    if (n < 0) continue;
                    SuperPanel.this.myItemPanel.addState(SuperPanel.this.multiStatePanel.getState(n));
                }
                SuperPanel.this.myItemPanel.updateList();
                SuperPanel.this.itemsPanel.setItems(SuperPanel.this.delta.getItemList(SuperPanel.this.myItemPanel.getStates()));
                SuperPanel.this.itemsPanel.updateList();
                if (SuperPanel.this.navikey.isIntelligence() || SuperPanel.this.navikey.isDependencies()) {
                    SuperPanel.this.itemCharacterPanel.setItemCharacters(SuperPanel.this.delta.getItemCharacterList(SuperPanel.this.myItemPanel.getStates(), SuperPanel.this.navikey.isIntelligence(), SuperPanel.this.navikey.isDependencies()));
                    SuperPanel.this.itemCharacterPanel.updateList();
                }
                SuperPanel.this.blankOutStatePanel();
            }
        }
    }
}

