/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.metadiversity.diversity.navikey.bo.BasicState;
import net.metadiversity.diversity.navikey.bo.NumericState;
import net.metadiversity.diversity.navikey.ui.NaviKey;

class NumericStatePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3834313933862744371L;
    BasicState toBeReturned;
    JLabel unit1;
    JLabel unit2;
    JLabel unit3;
    JTextField singleInput;
    JTextField lowerRange;
    JTextField upperRange;
    JCheckBox single;
    JCheckBox range;
    ButtonGroup cbg;
    JButton set;
    private boolean enableColorSelection = false;
    private ActionListener navikeyGuiListener;

    public NumericStatePanel() {
        this.setLayout(new GridLayout(5, 1));
        this.unit1 = new JLabel();
        this.unit2 = new JLabel();
        this.unit3 = new JLabel();
        this.singleInput = new JTextField(10);
        this.cbg = new ButtonGroup();
        this.lowerRange = new JTextField(10);
        this.lowerRange.setEditable(false);
        this.upperRange = new JTextField(10);
        this.upperRange.setEditable(false);
        this.cbg = new ButtonGroup();
        this.single = new JCheckBox("Single Measurement", true);
        this.cbg.add(this.single);
        this.range = new JCheckBox("Measurements fall in the range", false);
        this.cbg.add(this.range);
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.single);
        jPanel2.add(this.singleInput);
        jPanel2.add(this.unit1);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.range);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel("between");
        JLabel jLabel2 = new JLabel("and");
        jPanel4.add(jLabel);
        jPanel4.add(this.lowerRange);
        jPanel4.add(jLabel2);
        jPanel4.add(this.upperRange);
        jPanel4.add(this.unit3);
        this.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        this.set = new JButton("Add");
        this.set.setMaximumSize(new Dimension(150, 20));
        JLabel jLabel3 = new JLabel("");
        jPanel5.add("North", jLabel3);
        jPanel5.add("South", this.set);
        this.add(jPanel5);
        this.set.addActionListener(this);
        this.single.addActionListener(this);
        this.range.addActionListener(this);
        if (this.enableColorSelection) {
            this.singleInput.setBackground(NaviKey.boxBGColor);
            this.singleInput.setForeground(NaviKey.boxFGColor);
            this.lowerRange.setBackground(NaviKey.boxBGColor);
            this.lowerRange.setForeground(NaviKey.boxFGColor);
            this.upperRange.setBackground(NaviKey.boxBGColor);
            this.upperRange.setForeground(NaviKey.boxFGColor);
            this.set.setBackground(NaviKey.naviKeyBackgroundColor);
            this.set.setForeground(NaviKey.buttonColor);
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("NumericStatePanel : " + actionEvent);
        if (actionEvent.getSource() == this.range) {
            System.out.println("range");
            this.singleInput.setText("");
            this.singleInput.setEditable(false);
            this.lowerRange.setEditable(true);
            this.upperRange.setEditable(true);
        } else if (actionEvent.getSource() == this.single) {
            System.out.println("single");
            this.singleInput.setEditable(true);
            this.lowerRange.setText("");
            this.lowerRange.setEditable(false);
            this.upperRange.setText("");
            this.upperRange.setEditable(false);
        } else if (actionEvent.getSource() == this.set) {
            Object object;
            System.out.println("set");
            this.toBeReturned = new NumericState();
            if (this.single.isSelected()) {
                object = this.singleInput.getText();
                double d = this.toDouble((String)object);
                this.toBeReturned.setName(new Double(d).toString());
            } else if (this.range.isSelected()) {
                object = this.lowerRange.getText();
                double d = this.toDouble((String)object);
                object = this.upperRange.getText();
                double d2 = this.toDouble((String)object);
                this.toBeReturned.setName(d + "-" + d2);
            }
            object = new ActionEvent(this, 1, "Set numeric state");
            this.navikeyGuiListener.actionPerformed((ActionEvent)object);
        }
    }

    void updateGui() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "UpdateGui");
        this.navikeyGuiListener.actionPerformed(actionEvent);
    }

    public BasicState getState() {
        return this.toBeReturned;
    }

    public double toDouble(String string) {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    public void reset() {
        this.singleInput.setText("");
        this.lowerRange.setText("");
        this.upperRange.setText("");
    }

    public String getInput() {
        return this.singleInput.getText();
    }

    public void addNavikeyGuiListener(ActionListener actionListener) {
        this.navikeyGuiListener = actionListener;
    }

    public void setText(String string) {
        int n = string.lastIndexOf("[");
        if (n > 0) {
            this.unit1.setText(string.substring(n));
            this.unit2.setText(string.substring(n));
            this.unit3.setText(string.substring(n));
        } else {
            this.unit1.setText("");
            this.unit2.setText("");
            this.unit3.setText("");
        }
    }
}

