/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.metadiversity.diversity.navikey.bo.DeltaInterface;
import net.metadiversity.diversity.navikey.bo.Resource;
import net.metadiversity.diversity.navikey.delta.DeltaConnector;
import net.metadiversity.diversity.navikey.delta.DnDatabaseConnector;
import net.metadiversity.diversity.navikey.delta.LocalDeltaConnector;
import net.metadiversity.diversity.navikey.servlet.HttpDeltaConnector;
import net.metadiversity.diversity.navikey.ui.About;
import net.metadiversity.diversity.navikey.ui.ConfigurationPanel;
import net.metadiversity.diversity.navikey.ui.ImageViewer;
import net.metadiversity.diversity.navikey.ui.SuperPanel;
import net.metadiversity.diversity.navikey.util.NavikeyPopupSearchItem;
import net.metadiversity.diversity.navikey.util.SearchEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class NaviKey
extends JPanel {
    private static final long serialVersionUID = 3762532317360829234L;
    HashMap<String, HashMap<String, String>> itemMappingData;
    private boolean useTabSheets = false;
    JTabbedPane tabbedPane;
    SuperPanel superPanel;
    ConfigurationPanel cp;
    JLabel navikeyIcon = null;
    DeltaInterface delta;
    static Color naviKeyBackgroundColor = Color.black;
    static Color itemCharacterColor = Color.cyan;
    static Color itemStateColor = Color.magenta;
    static Color itemSelectionsColor = Color.green;
    static Color itemListColor = Color.yellow;
    static Color buttonColor = Color.pink;
    static Color boxBGColor = Color.white;
    static Color boxFGColor = Color.black;
    static Color itemDisplayColor = Color.cyan;
    static Color itemDisplayTextColor = Color.white;
    static Color itemDisplayBGColor = Color.darkGray;
    static Color itemDisplayFGColor = Color.green;
    static Color imageBGColor = Color.black;
    static Color imageFGColor = Color.white;
    private Color UriLocalAvailableColor = Color.GREEN;
    private Color UriRemoteAvailableColor = Color.ORANGE;
    private Color UriNotAvailableColor = Color.LIGHT_GRAY;
    private boolean standAlone = true;
    private boolean useDnDatabaseConnector = false;
    private String specsString = null;
    private String charsString = null;
    private String itemsString = null;
    private String tImagesString = null;
    private String specsFile = null;
    private String charsFile = null;
    private String itemsFile = null;
    private String tImagesFile = null;
    private String imageDirectory = null;
    private boolean useBestAlgorithm = false;
    private boolean intelligence = true;
    private boolean excludeUndefined = true;
    private boolean multipleSelectionOR = true;
    private boolean extremeInterval = true;
    private boolean overlappingInterval = true;
    public boolean dependenciesFlag = true;
    public boolean removeCharsCommentFlag = false;
    public boolean removeItemsCommentFlag = false;
    public boolean removeSpecsCommentFlag = false;
    public boolean removeCharsStatesCommentFlag = false;
    public boolean removeItemsStatesCommentFlag = false;
    public boolean removeSpecsStatesCommentFlag = false;
    public boolean showLiasUnitsFlag = false;
    private long allItemCount;
    private long foundItemCount;
    private String servletURL = null;
    private String configFileName = null;
    private URL codebase = null;
    private Container contentPane = null;
    private Resource resource;
    ArrayList<SearchEntry> itemsPanelSearchPopupsList = new ArrayList();
    JPopupMenu itemsPanelPopupMenu = null;
    String searchString = null;
    AppletContext navikeyAppletContext = null;

    public void setAppletContext(AppletContext appletContext) {
        this.navikeyAppletContext = appletContext;
    }

    private void readXmlConfig(URI uRI) {
        this.itemMappingData = new HashMap();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(uRI.toString());
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            System.out.println("NaviKey configuration: ");
            String string = null;
            String string2 = null;
            string2 = "/Config/Standalone";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.standAlone = string.equals("true");
            string2 = "/Config/ServletURL";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.servletURL = string;
            string2 = "/Config/Display/UseGuiTabs";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.useTabSheets = string.equals("true");
            string2 = "/Config/Display/ShowUnits";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.showLiasUnitsFlag = string.equals("true");
            string2 = "/Config/Display/RemoveCharsComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeCharsCommentFlag = string.equals("true");
            string2 = "/Config/Display/RemoveCharsStatesComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeCharsStatesCommentFlag = string.equals("true");
            string2 = "/Config/Display/RemoveItemsComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeItemsCommentFlag = string.equals("true");
            string2 = "/Config/Display/RemoveItemsStatesComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeItemsStatesCommentFlag = string.equals("true");
            string2 = "/Config/Display/RemoveSpecsComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeSpecsCommentFlag = string.equals("true");
            string2 = "/Config/Display/RemoveSpecsStatesComments";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.removeSpecsStatesCommentFlag = string.equals("true");
            Color color = null;
            string2 = "/Config/Display/PopUpMenu/URILocalAvailableColor";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            try {
                this.UriLocalAvailableColor = color = new Color(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Error in: Data ( " + string2 + " ): " + string);
            }
            string2 = "/Config/Display/PopUpMenu/URIRemoteAvailableColor";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            try {
                this.UriRemoteAvailableColor = color = new Color(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Error in: Data ( " + string2 + " ): " + string);
            }
            string2 = "/Config/Display/PopUpMenu/URINotAvailableColor";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            try {
                this.UriNotAvailableColor = color = new Color(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Error in: Data ( " + string2 + " ): " + string);
            }
            string2 = "/Config/MatchingOptions/UseBestAlgorithm";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.useBestAlgorithm = string.equals("true");
            string2 = "/Config/MatchingOptions/UseCharacterDependencies";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.dependenciesFlag = string.equals("true");
            string2 = "/Config/MatchingOptions/RestrictViewOnUsedCharactersAndCharacterStatesOfRemainingItems";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.intelligence = string.equals("true");
            string2 = "/Config/MatchingOptions/RetainItemsUnrecordedForTheSelectedCharacters";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.excludeUndefined = !string.equals("true");
            string2 = "/Config/MatchingOptions/RetainItemsMatchingAtLeastOneSelectedState";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.multipleSelectionOR = string.equals("true");
            string2 = "/Config/MatchingOptions/UseExtremeIntervalValidation";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.extremeInterval = string.equals("true");
            string2 = "/Config/MatchingOptions/UseOverlappingIntervalValidation";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.overlappingInterval = string.equals("true");
            string2 = "/Config/DataFiles/SpecsFileName";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.specsFile = string;
            string2 = "/Config/DataFiles/CharsFileName";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.charsFile = string;
            string2 = "/Config/DataFiles/ItemsFileName";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.itemsFile = string;
            string2 = "/Config/DataFiles/TimagesFileName";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.tImagesFile = string;
            string2 = "/Config/DataFiles/ImageDirectory";
            string = xPath.compile(string2).evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            this.imageDirectory = string;
            string2 = "/Config/Display/showLiasUnits";
            XPathExpression xPathExpression = xPath.compile(string2);
            string = xPathExpression.evaluate(document);
            System.out.println("Data ( " + string2 + " ): " + string);
            xPathExpression = xPath.compile("/Config/ItemURIs/*/child::text()");
            Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            int n = 0;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                SearchEntry searchEntry = new SearchEntry();
                searchEntry.setGuiString(nodeList.item(n2++).getNodeValue());
                searchEntry.setURI(nodeList.item(n2++).getNodeValue());
                searchEntry.setMappingFlag(nodeList.item(n2++).getNodeValue());
                searchEntry.setMappingFile(nodeList.item(n2++).getNodeValue());
                searchEntry.setRegex(nodeList.item(n2++).getNodeValue());
                this.itemsPanelSearchPopupsList.add(n++, searchEntry);
                if (!searchEntry.isMappingFlag()) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.itemMappingData.put(searchEntry.getGuiString(), hashMap);
                this.readItemMapping(searchEntry.getMappingFile(), hashMap);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            Logger.getLogger("global").log(Level.SEVERE, null, xPathExpressionException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.SEVERE, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.SEVERE, null, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.SEVERE, null, parserConfigurationException);
        }
    }

    private void initializeParameters() {
        Object var1_1 = null;
        Object var2_2 = null;
        String string = "NaviKeyConfig.xml";
        try {
            string = this.getParameter("configfile");
            URI uRI = new URI(this.getCodeBase().toString() + string);
            System.out.println("Config file URI: " + uRI);
            this.readXmlConfig(uRI);
        }
        catch (Exception exception) {
            System.out.println("Can't read configfile: " + string);
            this.standAlone = true;
            return;
        }
    }

    public NaviKey(Container container, String string, String string2, String string3) {
        this.specsString = string;
        this.charsString = string2;
        this.itemsString = string3;
        this.useDnDatabaseConnector = true;
        this.configFileName = "NaviKeyConfig.xml";
        this.contentPane = container;
        try {
            String string4 = System.getProperty("user.home");
            string4 = "FILE:///" + string4 + "/.diversity_navigator/";
            this.codebase = new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("NavikeyApplication: ERROR can't get CodeBase");
            malformedURLException.printStackTrace();
            this.codebase = null;
        }
    }

    public NaviKey(Container container, String string, URL uRL) {
        this.configFileName = string;
        this.codebase = uRL;
        this.contentPane = container;
    }

    private URL getCodeBase() {
        System.out.println("getCodeBase() : " + this.codebase);
        return this.codebase;
    }

    String getParameter(String string) {
        System.out.println("getParam( " + string + " )");
        if (string.equals("configfile")) {
            return this.configFileName;
        }
        return null;
    }

    Container getContentPane() {
        return this.contentPane;
    }

    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.initializeParameters();
        System.out.println("init()");
        if (this.imageDirectory != null) {
            // empty if block
        }
        DeltaConnector deltaConnector = this.useDnDatabaseConnector ? this.runDnDatabaseConnector() : (this.standAlone ? this.runStandAlone() : this.runHttpConnector());
        this.cp = new ConfigurationPanel(this, this.useTabSheets);
        this.createItemsPanelPopupMenu();
        this.delta = deltaConnector.getObject();
        this.superPanel = new SuperPanel(this, this.delta);
        System.out.println("Setting panels");
        this.superPanel.itemCharacterPanel.setItemCharacters(this.delta.getItemCharacterList(null, this.isIntelligence(), this.isDependencies()));
        this.superPanel.itemCharacterPanel.updateList();
        System.out.println("setting layouts");
        this.cp.addNavikeyGuiListener(this.superPanel.getNavikeyGuiListener("Options"));
        ActionEvent actionEvent = new ActionEvent(this, 1, "OptionsChanged");
        this.superPanel.getNavikeyGuiListener("Options").actionPerformed(actionEvent);
        this.superPanel.itemsPanel.setItems(this.delta.getItemList(null));
        this.superPanel.itemsPanel.updateList();
        System.out.println("Composing all");
        this.superPanel.build();
        ((CardLayout)this.superPanel.statePanel.getLayout()).first(this.superPanel.statePanel);
        this.superPanel.setSize(new Dimension(400, 640));
        if (this.useTabSheets) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.tabbedPane.add("Identification", this.superPanel);
            this.tabbedPane.add("Options", this.cp);
            this.tabbedPane.add("About", new About());
            this.getContentPane().add("Center", this.tabbedPane);
        } else {
            this.getContentPane().add("South", this.cp);
            this.getContentPane().add("Center", this.superPanel);
            try {
                this.navikeyIcon = new JLabel(new ImageIcon(new URL(this.getCodeBase() + "images/nlogo.gif")));
                this.getContentPane().add("North", this.navikeyIcon);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("NaviKey: image file not available" + malformedURLException);
            }
        }
        this.setVisible(true);
        System.out.println("NaviKey: Done with init");
    }

    public void showResult(String string, JPanel jPanel, String string2) {
        if (this.tabbedPane != null) {
            for (int i = this.tabbedPane.getTabCount(); i > 3; --i) {
                this.tabbedPane.remove(3);
            }
            this.tabbedPane.add(string, jPanel);
            this.tabbedPane.setSelectedIndex(3);
            try {
                if (string2 != null) {
                    ImageViewer imageViewer = new ImageViewer(new URL(this.getCodeBase() + "/" + this.imageDirectory + "/" + string2));
                    this.tabbedPane.add("Image", imageViewer);
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(malformedURLException);
                malformedURLException.printStackTrace();
            }
        }
    }

    private LocalDeltaConnector runStandAlone() {
        if (this.specsFile == null || this.charsFile == null || this.itemsFile == null) {
            System.out.println("NaviKey: Required files not specified.");
            System.out.println("NaviKey: use default filenames: chars, specs, items, timages.");
            this.specsFile = "specs";
            this.charsFile = "chars";
            this.itemsFile = "items";
            this.tImagesFile = "timages";
        }
        try {
            URL uRL = this.getCodeBase();
            String string = uRL.toString();
            System.out.println("Printme ");
            return new LocalDeltaConnector(this, string, this.specsFile, this.charsFile, this.itemsFile, this.tImagesFile);
        }
        catch (Exception exception) {
            System.out.println("NaviKey: Error reading delta files.\n" + exception);
            System.exit(0);
            return new LocalDeltaConnector(this);
        }
    }

    private HttpDeltaConnector runHttpConnector() {
        return new HttpDeltaConnector(this.servletURL);
    }

    private DnDatabaseConnector runDnDatabaseConnector() {
        return new DnDatabaseConnector(this, this.specsString, this.charsString, this.itemsString, this.tImagesString);
    }

    public boolean isExcludeUndefined() {
        return this.excludeUndefined;
    }

    public void setExcludeUndefined(boolean bl) {
        this.excludeUndefined = bl;
    }

    public boolean isExtremeInterval() {
        return this.extremeInterval;
    }

    public void setExtremeInterval(boolean bl) {
        this.extremeInterval = bl;
    }

    public boolean isIntelligence() {
        return this.intelligence;
    }

    public void setIntelligence(boolean bl) {
        this.intelligence = bl;
    }

    public boolean isDependencies() {
        return this.dependenciesFlag;
    }

    public void setDependencies(boolean bl) {
        this.dependenciesFlag = bl;
    }

    public boolean isMultipleSelectionOR() {
        return this.multipleSelectionOR;
    }

    public void setMultipleSelectionOR(boolean bl) {
        this.multipleSelectionOR = bl;
    }

    public boolean isOverlappingInterval() {
        return this.overlappingInterval;
    }

    public void setOverlappingInterval(boolean bl) {
        this.overlappingInterval = bl;
    }

    public boolean isRemoveCharsCommentFlag() {
        return this.removeCharsCommentFlag;
    }

    public boolean isRemoveItemsCommentFlag() {
        return this.removeItemsCommentFlag;
    }

    public boolean isRemoveSpecsCommentFlag() {
        return this.removeSpecsCommentFlag;
    }

    public boolean isRemoveCharsStatesCommentFlag() {
        return this.removeCharsStatesCommentFlag;
    }

    public boolean isRemoveItemsStatesCommentFlag() {
        return this.removeItemsStatesCommentFlag;
    }

    public boolean isRemoveSpecsStatesCommentFlag() {
        return this.removeSpecsStatesCommentFlag;
    }

    public boolean isShowLiasUnitsFlag() {
        return this.showLiasUnitsFlag;
    }

    public boolean isUseTabSheetsFlag() {
        return this.useTabSheets;
    }

    public long getAllItemCount() {
        return this.allItemCount;
    }

    public void setAllItemCount(long l) {
        this.allItemCount = l;
        this.cp.setTotalLabelText(Long.toString(l));
    }

    public long getFoundItemCount() {
        return this.foundItemCount;
    }

    public void setFoundItemCount(long l) {
        this.foundItemCount = l;
        this.cp.setResultLabelText(Long.toString(l));
    }

    private final void createItemsPanelPopupMenu() {
        this.itemsPanelPopupMenu = new JPopupMenu();
        PopupListener popupListener = new PopupListener();
        NavikeyPopupSearchItem navikeyPopupSearchItem = null;
        for (int i = 0; i < this.itemsPanelSearchPopupsList.size(); ++i) {
            navikeyPopupSearchItem = new NavikeyPopupSearchItem(this.itemsPanelSearchPopupsList.get(i).getGuiString(), this.itemsPanelSearchPopupsList.get(i).getURI(), this.itemsPanelSearchPopupsList.get(i).isMappingFlag(), this.itemsPanelSearchPopupsList.get(i).getRegex());
            navikeyPopupSearchItem.addMouseListener(popupListener);
            this.itemsPanelPopupMenu.add(navikeyPopupSearchItem);
        }
    }

    public final JPopupMenu getItemsPanelPopupMenu() {
        for (int i = 0; i < this.itemsPanelPopupMenu.getComponentCount(); ++i) {
            Component component = this.itemsPanelPopupMenu.getComponent(i);
            if (!component.getClass().getName().equals("net.metadiversity.diversity.navikey.util.NavikeyPopupSearchItem")) continue;
            NavikeyPopupSearchItem navikeyPopupSearchItem = (NavikeyPopupSearchItem)component;
            if (navikeyPopupSearchItem.isMappingFlag()) {
                String string = this.getTimageMapping(navikeyPopupSearchItem.getGuiText(), this.regexResult(navikeyPopupSearchItem.getRegex()));
                if (string != null) {
                    navikeyPopupSearchItem.setBackground(this.UriLocalAvailableColor);
                    continue;
                }
                navikeyPopupSearchItem.setBackground(this.UriRemoteAvailableColor);
                continue;
            }
            navikeyPopupSearchItem.setBackground(this.UriNotAvailableColor);
        }
        return this.itemsPanelPopupMenu;
    }

    private String regexResult(String string) {
        String string2 = null;
        if (string != null) {
            Pattern pattern = Pattern.compile(string, 64);
            Matcher matcher = pattern.matcher(this.searchString);
            System.out.println("String: " + this.searchString);
            if (matcher.find()) {
                string2 = matcher.group(0).trim();
                System.out.println("Regex result : " + string2);
            }
        }
        return string2;
    }

    void setSearchString(String string) {
        this.searchString = string;
    }

    private void search(String string, String string2) {
        System.out.println("Search " + string + " String: " + string2);
        if (this.navikeyAppletContext != null) {
            try {
                String string3 = null;
                string3 = URLEncoder.encode(string2, "UTF-8");
                string3 = string2.replace(" ", "%20");
                string = string.replace("[###]", string3);
                System.out.println(string);
                URI uRI = new URI(string);
                this.navikeyAppletContext.showDocument(uRI.toURL(), "_blank");
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, null, iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger("global").log(Level.SEVERE, null, uRISyntaxException);
            }
        } else if (Desktop.isDesktopSupported()) {
            try {
                Desktop desktop = Desktop.getDesktop();
                String string4 = null;
                string4 = URLEncoder.encode(string2, "UTF-8");
                string4 = string2.replace(" ", "%20");
                string = string.replace("[###]", string4);
                System.out.println(string);
                URI uRI = new URI(string);
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, null, iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger("global").log(Level.SEVERE, null, uRISyntaxException);
            }
        }
    }

    void readItemMapping(String string, HashMap<String, String> hashMap) {
        try {
            URI uRI = new URI(this.getCodeBase().toString() + string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            System.out.println("URI: " + uRI.toString());
            Document document = documentBuilder.parse(uRI.toString());
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("map")) continue;
                Node node2 = ((Element)node).getElementsByTagName("from").item(0);
                Node node3 = ((Element)node).getElementsByTagName("to").item(0);
                String string2 = ((Text)node2.getFirstChild()).getData();
                String string3 = ((Text)node3.getFirstChild()).getData();
                System.out.println(string2 + " " + string3);
                hashMap.put(string2, string3);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger("global").log(Level.SEVERE, "1", uRISyntaxException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.SEVERE, "2", sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.SEVERE, "3", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.SEVERE, "4", parserConfigurationException);
        }
    }

    public String getTimageMapping(String string, String string2) {
        return this.itemMappingData.get(string).get(string2);
    }

    public class PopupListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            System.out.println(((NavikeyPopupSearchItem)mouseEvent.getComponent().getComponentAt(mouseEvent.getPoint())).getText());
            NavikeyPopupSearchItem navikeyPopupSearchItem = (NavikeyPopupSearchItem)mouseEvent.getComponent().getComponentAt(mouseEvent.getPoint());
            String string = navikeyPopupSearchItem.getURI();
            String string2 = navikeyPopupSearchItem.getGuiText();
            String string3 = navikeyPopupSearchItem.getRegex();
            System.out.println("GUI:    " + string2);
            System.out.println("SERVER: " + string);
            System.out.println("REGEX:  " + string3);
            if (string3 != null) {
                Pattern pattern = Pattern.compile(string3, 64);
                Matcher matcher = pattern.matcher(NaviKey.this.searchString);
                System.out.println("String: " + NaviKey.this.searchString);
                if (matcher.find()) {
                    NaviKey.this.searchString = matcher.group(0).trim();
                    System.out.println("Regex result : " + NaviKey.this.searchString);
                }
            }
            if (navikeyPopupSearchItem.isMappingFlag()) {
                System.out.print("Map: " + NaviKey.this.searchString);
                NaviKey.this.searchString = NaviKey.this.getTimageMapping(navikeyPopupSearchItem.getGuiText(), NaviKey.this.searchString);
                System.out.println(" to " + NaviKey.this.searchString);
                if (NaviKey.this.searchString == null || NaviKey.this.searchString.length() <= 0) {
                    return;
                }
            }
            if (NaviKey.this.searchString != null) {
                NaviKey.this.search(string, NaviKey.this.searchString);
            }
        }
    }
}

