/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.metadiversity.diversity.navikey.bo.BasicItemCharacter;
import net.metadiversity.diversity.navikey.bo.BasicState;
import net.metadiversity.diversity.navikey.bo.DeltaInterface;
import net.metadiversity.diversity.navikey.ui.NaviKey;

class MyItemPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4050484504068370745L;
    Vector<BasicState> basicStates;
    JList theList;
    JScrollPane jScrollPane;
    JPanel buttonPanel;
    JButton remove;
    JButton reset;
    DeltaInterface delta;
    Vector<String> listData;
    private ActionListener navikeyGuiListener;
    private int selectedIndex = -1;
    private static final int VISIBLE_ROWS = 15;
    private boolean enableColorSelection = false;

    public MyItemPanel(DeltaInterface deltaInterface) {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Selection criteria");
        this.add("North", jLabel);
        this.listData = new Vector();
        this.delta = deltaInterface;
        this.basicStates = new Vector();
        this.theList = new JList<String>(this.listData);
        this.theList.setVisibleRowCount(15);
        this.theList.setSelectionMode(0);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setViewportView(this.theList);
        this.add("Center", this.jScrollPane);
        this.remove = new JButton("Remove Selection");
        this.reset = new JButton("Remove All");
        if (this.enableColorSelection) {
            this.theList.setBackground(NaviKey.naviKeyBackgroundColor);
            this.theList.setForeground(NaviKey.itemSelectionsColor);
            this.remove.setBackground(Color.black);
            this.remove.setForeground(Color.pink);
            this.reset.setBackground(Color.black);
            this.reset.setForeground(Color.pink);
        }
        this.buttonPanel = new JPanel(new BorderLayout());
        this.buttonPanel.add("West", this.remove);
        this.buttonPanel.add("East", this.reset);
        this.setVisible(true);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MyItemPanel.this.selectedIndex = MyItemPanel.this.theList.getAnchorSelectionIndex();
                if (MyItemPanel.this.selectedIndex != -1) {
                    MyItemPanel.this.removeStateAt(MyItemPanel.this.selectedIndex);
                    MyItemPanel.this.updateList();
                    MyItemPanel.this.updateGui();
                }
            }
        });
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MyItemPanel.this.removeAllStates();
                MyItemPanel.this.updateList();
                MyItemPanel.this.updateGui();
            }
        });
        this.add("South", this.buttonPanel);
    }

    public void updateList() {
        this.listData.clear();
        Object var1_1 = null;
        for (int i = 0; i < this.basicStates.size(); ++i) {
            BasicState basicState = this.basicStates.elementAt(i);
            BasicItemCharacter basicItemCharacter = this.delta.getBasicItemCharacter(basicState.getCharacterId());
            this.listData.add(basicItemCharacter.getFeature() + ":  " + basicState.getName());
        }
        this.theList.setListData(this.listData);
    }

    public Vector<BasicState> getStates() {
        return this.basicStates;
    }

    public void setStates(Vector<BasicState> vector) {
        this.basicStates = vector;
    }

    public void addState(BasicState basicState) {
        this.basicStates.addElement(basicState);
    }

    public void removeStateAt(int n) {
        this.basicStates.removeElementAt(n);
    }

    public void removeAllStates() {
        this.basicStates.removeAllElements();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("MyItemPanel : " + actionEvent);
        this.selectedIndex = this.theList.getSelectedIndex();
        System.out.println(this.selectedIndex);
        System.out.println(this.theList.getAnchorSelectionIndex());
        System.out.println(this.theList.getLeadSelectionIndex());
    }

    void updateGui() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "UpdateGui");
        this.navikeyGuiListener.actionPerformed(actionEvent);
    }

    public void addNavikeyGuiListener(ActionListener actionListener) {
        this.navikeyGuiListener = actionListener;
    }
}

