/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.metadiversity.diversity.navikey.bo.BasicState;
import net.metadiversity.diversity.navikey.ui.NaviKey;

class MultiStatePanel
extends JPanel {
    private static final long serialVersionUID = 3257008769614690608L;
    private Vector<BasicState> basicStates;
    private JList theList;
    private JScrollPane jScrollPane;
    private Vector<String> listData = new Vector();
    private JButton selectButton;
    private ActionListener navikeyGuiListener;
    private static final int VISIBLE_ROWS = 15;
    private boolean enableColorSelection = false;

    public MultiStatePanel() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Character states available");
        this.add("North", jLabel);
        this.basicStates = new Vector();
        this.theList = new JList<String>(this.listData);
        this.theList.setVisibleRowCount(15);
        this.theList.setSelectionMode(0);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setViewportView(this.theList);
        this.add("Center", this.jScrollPane);
        this.selectButton = new JButton("Select");
        this.add("South", this.selectButton);
        if (this.enableColorSelection) {
            this.theList.setBackground(NaviKey.naviKeyBackgroundColor);
            this.theList.setForeground(NaviKey.itemStateColor);
        }
        this.setVisible(true);
        this.theList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MultiStatePanel.this.ValueChanged(listSelectionEvent);
            }
        });
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(actionEvent.toString());
                MultiStatePanel.this.updateGui();
            }
        });
    }

    void updateGui() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "UpdateGui");
        this.navikeyGuiListener.actionPerformed(actionEvent);
    }

    private void ValueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.theList.setSelectionMode(2);
        this.theList.addListSelectionListener(listSelectionListener);
    }

    public BasicState getState(int n) {
        return this.basicStates.elementAt(n);
    }

    public void setStates(Vector<BasicState> vector) {
        this.basicStates = vector;
    }

    public void updateList() {
        Comparator<BasicState> comparator = new Comparator<BasicState>(){

            @Override
            public int compare(BasicState basicState, BasicState basicState2) {
                return basicState.getName().compareTo(basicState2.getName());
            }
        };
        Collections.sort(this.basicStates, comparator);
        this.listData.removeAllElements();
        for (int i = 0; i < this.basicStates.size(); ++i) {
            BasicState basicState = this.basicStates.elementAt(i);
            this.listData.add(basicState.getName());
        }
        this.theList.setListData(this.listData);
    }

    public JList getTheList() {
        return this.theList;
    }

    public void addNavikeyGuiListener(ActionListener actionListener) {
        this.navikeyGuiListener = actionListener;
    }
}

