/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.BasicConfigurator;

public class ImageViewer
extends JPanel {
    private static final long serialVersionUID = 3258417231057596473L;
    private JScrollPane imageScrollPane;
    private JPanel zoomPanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton saveButton;
    ImageIcon imageIcon;
    JLabel imageLabel;
    double zoomFactor = 1.0;
    AffineTransformOp transform;
    AffineTransform t = new AffineTransform();
    private BufferedImage srcImage;
    private BufferedImage destImage;
    private static final String ZOOM_IN_LABEL = "Zoom In";
    private static final String ZOOM_OUT_LABEL = "Zoom Out";
    private static final String SAVE_LABEL = "Save image";

    public ImageViewer(URL uRL) {
        try {
            this.loadImage(uRL);
            this.imageIcon = new ImageIcon(this.destImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initComponents();
        this.repaint();
    }

    private void loadImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = null;
        if (uRL != null) {
            System.out.println(uRL.toString());
            try {
                bufferedImage = ImageIO.read(uRL);
            }
            catch (IIOException iIOException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(100, 200, 1);
        }
        this.srcImage = new BufferedImage((int)((double)((Image)bufferedImage).getWidth(null) * this.zoomFactor), (int)((double)((Image)bufferedImage).getHeight(null) * this.zoomFactor), 1);
        Graphics2D graphics2D = this.srcImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        this.destImage = new BufferedImage((int)((double)this.srcImage.getWidth() * this.zoomFactor), (int)((double)this.srcImage.getHeight() * this.zoomFactor), 1);
        Graphics2D graphics2D2 = this.destImage.createGraphics();
        graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
    }

    public void showUrl(URL uRL) {
        try {
            this.loadImage(uRL);
            this.imageIcon = new ImageIcon(this.destImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.zoomFactor = 1.0;
        this.t.setToScale(this.zoomFactor, this.zoomFactor);
        this.destImage = new BufferedImage((int)((double)this.srcImage.getWidth() * this.zoomFactor), (int)((double)this.srcImage.getHeight() * this.zoomFactor), this.srcImage.getType());
        this.transform = new AffineTransformOp(this.t, 1);
        this.transform.filter(this.srcImage, this.destImage);
        this.imageIcon = new ImageIcon(this.destImage);
        this.imageLabel.setIcon(this.imageIcon);
        this.imageScrollPane.setViewportView(this.imageLabel);
        this.repaint();
    }

    private void initComponents() {
        this.imageIcon = new ImageIcon(this.destImage);
        this.imageLabel = new JLabel(this.imageIcon);
        this.zoomPanel = new JPanel();
        this.imageScrollPane = new JScrollPane();
        this.zoomOutButton = new JButton();
        this.zoomInButton = new JButton();
        this.saveButton = new JButton();
        this.setLayout(new BorderLayout());
        this.imageScrollPane.setViewportView(this.imageLabel);
        this.add((Component)this.imageScrollPane, "Center");
        this.zoomOutButton.setText(ZOOM_OUT_LABEL);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.zoomOutButtonActionPerformed(actionEvent);
            }
        });
        this.zoomPanel.add(this.zoomOutButton);
        this.zoomInButton.setText(ZOOM_IN_LABEL);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.zoomInButtonActionPerformed(actionEvent);
            }
        });
        this.zoomPanel.add(this.zoomInButton);
        this.add((Component)this.zoomPanel, "South");
    }

    private void zoomInButtonActionPerformed(ActionEvent actionEvent) {
        this.zoomFactor *= 1.33;
        this.t.setToScale(this.zoomFactor, this.zoomFactor);
        this.destImage = new BufferedImage((int)((double)this.srcImage.getWidth() * this.zoomFactor), (int)((double)this.srcImage.getHeight() * this.zoomFactor), this.srcImage.getType());
        this.transform = new AffineTransformOp(this.t, 1);
        this.transform.filter(this.srcImage, this.destImage);
        this.imageIcon = new ImageIcon(this.destImage);
        this.imageLabel.setIcon(this.imageIcon);
        this.imageScrollPane.setViewportView(this.imageLabel);
        this.repaint();
    }

    private void zoomOutButtonActionPerformed(ActionEvent actionEvent) {
        this.zoomFactor *= 0.75;
        this.t.setToScale(this.zoomFactor, this.zoomFactor);
        this.destImage = new BufferedImage((int)((double)this.srcImage.getWidth() * this.zoomFactor), (int)((double)this.srcImage.getHeight() * this.zoomFactor), this.srcImage.getType());
        this.transform = new AffineTransformOp(this.t, 1);
        this.transform.filter(this.srcImage, this.destImage);
        this.imageIcon = new ImageIcon(this.destImage);
        this.imageLabel.setIcon(this.imageIcon);
        this.imageScrollPane.setViewportView(this.imageLabel);
        this.repaint();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(SAVE_LABEL);
        jFileChooser.setFileSelectionMode(0);
        ImageFileFilter imageFileFilter = new ImageFileFilter();
        jFileChooser.setFileFilter(imageFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            try {
                ImageIO.write((RenderedImage)this.destImage, "png", jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Object object;
        BasicConfigurator.configure();
        ImageViewer imageViewer = null;
        try {
            object = "./dn-cvs-096/dncode/net/metadiversity/diversity/navigator/images/dn.gif";
            imageViewer = new ImageViewer(new URL("http://geo.cbs.umn.edu/treekey/images/AlnusviridisLamvarcrispa.gif"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = new JFrame();
        ((JFrame)object).getContentPane().add((Component)imageViewer, "Center");
        ((JFrame)object).setDefaultCloseOperation(3);
        ((Window)object).setSize(500, 100);
        ((Window)object).pack();
        ((Window)object).setVisible(true);
        ((Window)object).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }

    public class ImageFileFilter
    extends FileFilter {
        public static final String png = ".png";

        ImageFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(png);
        }

        @Override
        public String getDescription() {
            return "png image format";
        }
    }
}

