/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.ui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.metadiversity.diversity.navikey.ui.InfoFrame;
import net.metadiversity.diversity.navikey.ui.NaviKey;

class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 4051049644454720816L;
    private JCheckBox useBestAlgorithm;
    private JCheckBox useCharacterDependencies;
    private JCheckBox smartsbox;
    private JCheckBox excludeUndefined;
    private JCheckBox multipleSelectionAndOr;
    private JCheckBox extremeInterval;
    private JCheckBox overlappingInterval;
    private JCheckBox dependencies;
    private JButton infobutton;
    private JPanel totalItemCount;
    private JLabel totalLabel;
    private JLabel totalCount;
    private JPanel resultItemCount;
    private JLabel resultLabel;
    private JLabel resultCount;
    private ActionListener navikeyGuiListener;
    private NaviKey navikey;

    public ConfigurationPanel(NaviKey naviKey) {
        new ConfigurationPanel(naviKey, false);
    }

    public ConfigurationPanel(NaviKey naviKey, boolean bl) {
        this.navikey = naviKey;
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("NaviKey options: ");
        jLabel.setVerticalAlignment(1);
        this.useBestAlgorithm = new JCheckBox("Use \"Best\" algorithm (To be implemented)");
        this.useBestAlgorithm.setEnabled(false);
        this.useCharacterDependencies = new JCheckBox("Use character dependencies");
        this.useCharacterDependencies.setSelected(naviKey.isDependencies());
        this.useCharacterDependencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.dependenciesActionPerformed(actionEvent);
            }
        });
        this.smartsbox = new JCheckBox("Restrict view on used characters and character states of remaining items");
        this.smartsbox.setSelected(naviKey.isIntelligence());
        this.smartsbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.smartsBoxActionPerformed(actionEvent);
            }
        });
        this.excludeUndefined = new JCheckBox("Retain items unrecorded for the selected characters");
        this.excludeUndefined.setSelected(!naviKey.isExcludeUndefined());
        this.excludeUndefined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.excludeUndefinedActionPerformed(actionEvent);
            }
        });
        this.multipleSelectionAndOr = new JCheckBox("Retain items matching at least one selected state");
        this.multipleSelectionAndOr.setSelected(naviKey.isMultipleSelectionOR());
        this.multipleSelectionAndOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.multipleSelectionAndOrActionPerformed(actionEvent);
            }
        });
        this.extremeInterval = new JCheckBox("Use extreme interval validation");
        this.extremeInterval.setSelected(naviKey.isExtremeInterval());
        this.extremeInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.extremeIntervalActionPerformed(actionEvent);
            }
        });
        this.overlappingInterval = new JCheckBox("Use overlapping interval validation");
        this.overlappingInterval.setSelected(naviKey.isOverlappingInterval());
        this.overlappingInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationPanel.this.overlappingIntervalActionPerformed(actionEvent);
            }
        });
        if (!bl) {
            this.infobutton = new JButton("About NaviKey");
            this.infobutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigurationPanel.this.infoButtonActionPerformed(actionEvent);
                }
            });
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 1));
        jPanel.add(this.useBestAlgorithm);
        jPanel.add(this.useCharacterDependencies);
        jPanel.add(this.smartsbox);
        jPanel.add(this.excludeUndefined);
        jPanel.add(this.multipleSelectionAndOr);
        jPanel.add(this.extremeInterval);
        jPanel.add(this.overlappingInterval);
        this.add("West", jLabel);
        this.add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        if (bl) {
            jPanel2.setLayout(new GridLayout(1, 2));
            this.totalItemCount = new JPanel();
            this.totalItemCount.setLayout(new GridLayout(1, 2));
            this.totalLabel = new JLabel("All items: ");
            this.totalCount = new JLabel("??");
            this.totalItemCount.add(this.totalLabel);
            this.totalItemCount.add(this.totalCount);
            this.resultItemCount = new JPanel();
            this.resultItemCount.setLayout(new GridLayout(1, 2));
            this.resultLabel = new JLabel("Resulting items: ");
            this.resultCount = new JLabel("?");
            this.resultItemCount.add(this.resultLabel);
            this.resultItemCount.add(this.resultCount);
            jPanel2.add(this.totalItemCount);
            jPanel2.add(this.resultItemCount);
            naviKey.getContentPane().add("South", jPanel2);
        } else {
            jPanel2.setLayout(new GridLayout(3, 1));
            this.totalItemCount = new JPanel();
            this.totalItemCount.setLayout(new GridLayout(1, 2));
            this.totalLabel = new JLabel("All items: ");
            this.totalCount = new JLabel("??");
            this.totalItemCount.add(this.totalLabel);
            this.totalItemCount.add(this.totalCount);
            this.resultItemCount = new JPanel();
            this.resultItemCount.setLayout(new GridLayout(1, 2));
            this.resultLabel = new JLabel("Resulting items: ");
            this.resultCount = new JLabel("?");
            this.resultItemCount.add(this.resultLabel);
            this.resultItemCount.add(this.resultCount);
            jPanel2.add(this.totalItemCount);
            jPanel2.add(this.resultItemCount);
            jPanel2.add(this.infobutton);
            this.add("East", jPanel2);
        }
        this.setVisible(true);
    }

    private void infoButtonActionPerformed(ActionEvent actionEvent) {
        System.out.println("Info about NaviKey:");
        InfoFrame infoFrame = new InfoFrame();
        infoFrame.setSize(500, 450);
        infoFrame.setVisible(true);
    }

    private void smartsBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.smartsbox.isSelected();
        this.navikey.setIntelligence(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    private void excludeUndefinedActionPerformed(ActionEvent actionEvent) {
        boolean bl = !this.excludeUndefined.isSelected();
        this.navikey.setExcludeUndefined(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    private void multipleSelectionAndOrActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.multipleSelectionAndOr.isSelected();
        this.navikey.setMultipleSelectionOR(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    private void extremeIntervalActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.extremeInterval.isSelected();
        this.navikey.setExtremeInterval(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    private void overlappingIntervalActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.overlappingInterval.isSelected();
        this.navikey.setOverlappingInterval(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    private void dependenciesActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.useCharacterDependencies.isSelected();
        this.navikey.setDependencies(bl);
        ActionEvent actionEvent2 = new ActionEvent(this, 1, "OptionsChanged");
        this.navikeyGuiListener.actionPerformed(actionEvent2);
    }

    public void addNavikeyGuiListener(ActionListener actionListener) {
        this.navikeyGuiListener = actionListener;
    }

    public void setResultLabelText(String string) {
        this.resultCount.setText(string);
        this.resultCount.repaint();
    }

    public void setTotalLabelText(String string) {
        this.totalCount.setText(string);
        this.totalCount.repaint();
    }
}

