/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.persistent;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class Database {
    Connection con;
    ResultSet rs;
    Statement stmt;
    String jdbcStack;
    String url;
    String userName;
    String password;

    public void connect(String string, String string2, String string3, String string4) throws Exception {
        this.jdbcStack = string;
        this.url = string2;
        this.userName = string3;
        this.password = string4;
        try {
            Class.forName(string);
            System.out.println("Connecting to " + string2);
            this.con = DriverManager.getConnection(string2, string3, string4);
        }
        catch (Exception exception) {
            System.err.println("System Exeception in connect");
            System.err.println(exception);
            throw exception;
        }
    }

    public void reconnect() {
        try {
            this.connect(this.jdbcStack, this.url, this.userName, this.password);
        }
        catch (Exception exception) {
            System.err.println("System Exeception in reconnect");
            System.err.println(exception);
        }
    }

    public void closeConnection() throws Exception {
        try {
            System.out.println("Closing connection");
            this.con.close();
            this.rs.close();
            this.stmt.close();
        }
        catch (Exception exception) {
            System.err.println("System Exception in closeConnection");
            System.err.println(exception);
            throw exception;
        }
    }

    private void checkForWarning(SQLWarning sQLWarning) throws SQLException {
        boolean bl = false;
        if (sQLWarning != null) {
            System.out.println("*Warning*");
            bl = true;
            while (sQLWarning != null) {
                System.out.println("SQLState: " + sQLWarning.getSQLState());
                System.out.println("Message:  " + sQLWarning.getMessage());
                System.out.println("Vendor:   " + sQLWarning.getErrorCode());
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
    }

    public ResultSet select(String string) throws Exception {
        try {
            if (this.con.isClosed()) {
                System.err.println("Select: connection is not open");
                this.reconnect();
            }
            this.stmt = this.con.createStatement();
            this.rs = this.stmt.executeQuery(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.rs;
    }

    public void update(String string) throws Exception {
        try {
            if (this.con.isClosed()) {
                System.err.println("Update: connection is not open");
                this.reconnect();
            }
            this.stmt = this.con.createStatement();
            this.stmt.executeUpdate(string);
        }
        catch (Exception exception) {
            System.err.println("Update failed:" + exception);
        }
    }
}

