/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.delta;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import net.metadiversity.diversity.navigator.db.delta_editor.Dependencies;
import net.metadiversity.diversity.navikey.delta.ItemCharacterType;
import net.metadiversity.diversity.navikey.util.DeltaFileUtils;

public class SpecsFileReader {
    StringBuffer itemCharacterTypeLines;
    StringBuffer itemCharacterDependencyLines = new StringBuffer();
    StringBuffer itemImpliciteValuesLines;
    String itemImpliciteValues = null;
    Vector<ItemCharacterType> itemCharacterTypes;
    Vector<Dependencies> dependenciesVector;
    String CHARACTER_TYPES = "CHARACTER TYPES";
    String DEPENDENT_CHARACTERS = "DEPENDENT CHARACTERS";
    String MANDATORY = "MANDATORY";
    String IMPLICIT_VALUES = "IMPLICIT VALUES";

    public SpecsFileReader() {
        this.itemCharacterTypeLines = new StringBuffer();
        this.itemImpliciteValuesLines = new StringBuffer();
        this.itemCharacterTypes = new Vector();
    }

    public Vector getItemCharacterTypes() {
        return this.itemCharacterTypes;
    }

    public Vector<Dependencies> getDependenciesVector() {
        return this.dependenciesVector;
    }

    public String getImplicideValues() {
        return this.itemImpliciteValues;
    }

    public void read(String string) {
        BufferedReader bufferedReader = null;
        try {
            System.out.println("SpecsFileReader(), read UTF-8 file: " + string);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            this.read(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(string + " not found");
            return;
        }
    }

    public void read(BufferedReader bufferedReader) {
        this.read(bufferedReader, false, false);
    }

    void read(BufferedReader bufferedReader, boolean bl, boolean bl2) {
        String string = "";
        int n = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (string != null) {
            ++n;
            try {
                boolean bl6;
                string = bufferedReader.readLine();
                if (string == null) continue;
                if ((string = string.trim()).indexOf("*") == 0) {
                    bl6 = true;
                    bl3 = false;
                } else {
                    bl6 = false;
                }
                if (DeltaFileUtils.containsDirective(string, this.CHARACTER_TYPES)) {
                    bl3 = true;
                    bl4 = false;
                    bl5 = false;
                }
                if (DeltaFileUtils.containsDirective(string, this.DEPENDENT_CHARACTERS)) {
                    bl4 = true;
                    bl3 = false;
                    bl5 = false;
                }
                if (DeltaFileUtils.containsDirective(string, this.IMPLICIT_VALUES)) {
                    bl5 = true;
                    bl4 = false;
                    bl3 = false;
                } else {
                    bl4 = false;
                }
                if (DeltaFileUtils.containsDirective(string, this.MANDATORY)) {
                    bl4 = false;
                    bl3 = false;
                    bl5 = false;
                }
                if (bl3) {
                    this.itemCharacterTypeLines.append(" ").append(string);
                }
                if (bl4) {
                    this.itemCharacterDependencyLines.append(" ").append(string);
                }
                if (!bl5) continue;
                this.itemImpliciteValuesLines.append(" ").append(string);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    public void makeItemCharacterTypes() {
        if (this.itemCharacterTypeLines == null) {
            return;
        }
        if (this.itemCharacterTypeLines.length() < this.CHARACTER_TYPES.length() + 3) {
            return;
        }
        String string = this.itemCharacterTypeLines.substring(this.CHARACTER_TYPES.length() + 3);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            Integer n;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, "-");
            if (stringTokenizer3.countTokens() == 2) {
                n = new Integer(stringTokenizer3.nextToken());
                Integer n2 = new Integer(stringTokenizer3.nextToken());
                System.out.println("Start:" + n + " End:" + n2 + " Type:" + string4);
                for (int i = n.intValue(); i <= n2; ++i) {
                    this.itemCharacterTypes.addElement(new ItemCharacterType(new Integer(i), string4));
                }
                continue;
            }
            n = new Integer(stringTokenizer3.nextToken());
            this.itemCharacterTypes.addElement(new ItemCharacterType(n, string4));
        }
    }

    public void makeItemCharacterDependencies() {
        boolean bl = false;
        this.dependenciesVector = new Vector();
        if (this.itemCharacterDependencyLines.length() < this.DEPENDENT_CHARACTERS.length() + 3) {
            return;
        }
        String string = this.itemCharacterDependencyLines.substring(this.DEPENDENT_CHARACTERS.length() + 3);
        if (bl) {
            System.out.println("allLines: " + string);
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                System.out.println("Unparsed String: " + string2);
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            int n = string4.indexOf(58);
            String string5 = string4.substring(++n);
            string4 = string4.substring(0, --n);
            if (bl) {
                System.out.println(string3);
                System.out.println(string4);
                System.out.println(string5);
            }
            DeltaRange deltaRange = new DeltaRange(string4, '/', '-');
            DeltaRange deltaRange2 = new DeltaRange(string5, ':', '-');
            try {
                for (int i = 0; i < deltaRange.v.size(); ++i) {
                    for (int j = 0; j < deltaRange2.v.size(); ++j) {
                        if (bl) {
                            System.out.println("DEPENDENT " + string3 + " " + deltaRange.v.get(i) + " " + deltaRange2.v.get(j));
                        }
                        int n2 = Integer.parseInt(string3);
                        int n3 = (Integer)deltaRange.getVector().get(i);
                        int n4 = (Integer)deltaRange2.getVector().get(j);
                        this.dependenciesVector.add(new Dependencies(n2, n3, n4));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    public void makeImpliciteValues() {
        this.itemImpliciteValues = null;
        if (this.itemImpliciteValuesLines == null) {
            return;
        }
        if (this.itemImpliciteValuesLines.length() < this.IMPLICIT_VALUES.length() + 3) {
            return;
        }
        this.itemImpliciteValues = this.itemImpliciteValuesLines.substring(this.IMPLICIT_VALUES.length() + 3);
    }

    public void print() {
        System.out.println("itemCharacter Types:");
        for (int i = 0; i < this.itemCharacterTypes.size(); ++i) {
            ItemCharacterType itemCharacterType = this.itemCharacterTypes.elementAt(i);
            itemCharacterType.print();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: SpecsFileReader <specs file name>");
            System.exit(0);
        }
        SpecsFileReader specsFileReader = new SpecsFileReader();
        specsFileReader.read(stringArray[0]);
        specsFileReader.makeItemCharacterTypes();
        specsFileReader.makeItemCharacterDependencies();
        specsFileReader.print();
    }

    class DeltaRange {
        Vector<Integer> v;
        String delim;
        String range;
        boolean debug = false;

        public DeltaRange(String string, char c, char c2) {
            this.delim = String.valueOf(c);
            this.range = String.valueOf(c2);
            String string2 = this.delim + this.range;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            this.v = new Vector();
            boolean bl = true;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while (stringTokenizer.hasMoreElements()) {
                string3 = string5;
                string5 = stringTokenizer.nextToken();
                if (!bl) {
                    if (this.debug) {
                        System.out.println(string + " " + string4 + " " + string5 + " " + string3);
                    }
                    if (string4.compareTo(this.range) == 0) {
                        for (int i = Integer.parseInt(string3); i <= Integer.parseInt(string5); ++i) {
                            if (this.debug) {
                                System.out.println("add: " + i);
                            }
                            this.v.add(new Integer(i));
                        }
                    } else {
                        if (this.debug) {
                            System.out.println("add: " + Integer.parseInt(string5));
                        }
                        this.v.add(new Integer(Integer.parseInt(string5)));
                    }
                } else {
                    if (this.debug) {
                        System.out.println("add: " + Integer.parseInt(string5));
                    }
                    this.v.add(new Integer(Integer.parseInt(string5)));
                    string5 = String.valueOf(Integer.parseInt(string5) + 1);
                    bl = false;
                }
                if (!stringTokenizer.hasMoreElements()) continue;
                string4 = stringTokenizer.nextToken();
            }
        }

        public boolean inRange(int n) {
            return this.v.contains(new Integer(n));
        }

        public Vector getVector() {
            return this.v;
        }
    }
}

