/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.delta;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import net.metadiversity.diversity.navikey.bo.ItemCharacter;
import net.metadiversity.diversity.navikey.bo.MultiState;
import net.metadiversity.diversity.navikey.bo.NumericState;
import net.metadiversity.diversity.navikey.bo.State;
import net.metadiversity.diversity.navikey.bo.TextState;
import net.metadiversity.diversity.navikey.delta.ItemCharacterType;
import net.metadiversity.diversity.navikey.delta.SpecsFileReader;
import net.metadiversity.diversity.navikey.util.DeltaDataString;
import net.metadiversity.diversity.navikey.util.DeltaFileUtils;
import net.metadiversity.diversity.navikey.util.NewStringTokenizer;

public class CharsFileReader {
    private Hashtable<Integer, ItemCharacter> itemCharacters = new Hashtable();
    private Vector itemCharacterTypes;
    private boolean setUnitFlag = true;

    public void setItemCharacterTypes(Vector vector) {
        this.itemCharacterTypes = vector;
    }

    public String lookupItemCharacterTypeAbbrev(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            String string = "UM";
            for (int i = 0; i < this.itemCharacterTypes.size(); ++i) {
                ItemCharacterType itemCharacterType = (ItemCharacterType)this.itemCharacterTypes.elementAt(i);
                if (itemCharacterType.getId().intValue() != n.intValue()) continue;
                string = itemCharacterType.getAbbrev();
            }
            return string;
        }
        return null;
    }

    public Hashtable getItemCharacters() {
        return this.itemCharacters;
    }

    public void print() {
    }

    public void read(String string, boolean bl, boolean bl2) {
        BufferedReader bufferedReader = null;
        try {
            System.out.println("CharsFileReader(), read UTF-8 file: " + string);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            this.read(bufferedReader, bl, bl2);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(string + " not found");
            return;
        }
    }

    public void read(BufferedReader bufferedReader, boolean bl, boolean bl2) {
        int n;
        String string = "";
        Vector<StringBuffer> vector = new Vector<StringBuffer>();
        int n2 = 0;
        int n3 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        while (string != null) {
            ++n2;
            try {
                string = bufferedReader.readLine();
                if (string == null) continue;
                string = string.replaceAll("\\\\[^\\{]*\\{\\}", "");
                n = DeltaFileUtils.containsDirective(string = string.trim(), "CHARACTER LIST");
                if (n != 0) {
                    bl3 = true;
                } else if (bl3 && string.indexOf("*") == 0) {
                    bl4 = true;
                }
                if (!bl3 || bl4) continue;
                if (this.isFeatureDescription(string)) {
                    ++n3;
                    vector.addElement(new StringBuffer(string.replace('\t', ' ')));
                    continue;
                }
                if (n3 <= -1) continue;
                ((StringBuffer)vector.elementAt(n3)).append(" " + string.replace('\t', ' '));
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        System.out.println("done reading file");
        System.out.println("Processing " + vector.size() + " descriptions");
        for (n = 0; n < vector.size(); ++n) {
            DeltaDataString deltaDataString = new DeltaDataString((StringBuffer)vector.elementAt(n), bl, bl2);
            ItemCharacter itemCharacter = this.makeItemCharacter(deltaDataString.getString());
            this.itemCharacters.put(itemCharacter.getId(), itemCharacter);
        }
    }

    private boolean isFeatureDescription(String string) {
        if (string.length() < 4) {
            return false;
        }
        if (string.charAt(0) != '#') {
            return false;
        }
        int n = string.indexOf(". ");
        int n2 = 1;
        while (string.charAt(n2) == ' ') {
            ++n2;
        }
        String string2 = string.substring(n2, n);
        try {
            Integer n3 = new Integer(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public ItemCharacter makeItemCharacter(String string) {
        ItemCharacter itemCharacter = new ItemCharacter();
        NewStringTokenizer newStringTokenizer = new NewStringTokenizer(string, "/ ");
        int n = 0;
        String string2 = "";
        while (newStringTokenizer.hasMoreTokens()) {
            State state;
            String string3 = newStringTokenizer.nextToken().trim();
            if (++n == 1) {
                this.parseFeatureDescription(string3, itemCharacter);
                if (itemCharacter.getId() == null) {
                    System.out.print("failed to parse feature description: " + string3);
                    string2 = "";
                    continue;
                }
                string2 = this.lookupItemCharacterTypeAbbrev(itemCharacter.getId());
                itemCharacter.setType(string2);
                continue;
            }
            if (itemCharacter.getType().equals("UM") || itemCharacter.getType().equals("OM")) {
                state = this.parseMultiState(string3, string2);
                if (state == null) continue;
                state.setItemCharacter(itemCharacter);
                itemCharacter.addState(state);
                continue;
            }
            if (itemCharacter.getType().equals("IN")) {
                state = new NumericState();
                ((NumericState)state).isInteger(true);
                state.setName(string3);
                state.setItemCharacter(itemCharacter);
                itemCharacter.addState(state);
                if (!this.setUnitFlag || n != 2 || itemCharacter.getFeature().indexOf(91) >= 0) continue;
                itemCharacter.setFeature(itemCharacter.getFeature() + " [" + string3 + "]");
                continue;
            }
            if (itemCharacter.getType().equals("RN")) {
                state = new NumericState();
                ((NumericState)state).isReal(true);
                state.setName(string3);
                state.setItemCharacter(itemCharacter);
                itemCharacter.addState(state);
                if (!this.setUnitFlag || n != 2 || itemCharacter.getFeature().indexOf(91) >= 0) continue;
                itemCharacter.setFeature(itemCharacter.getFeature() + " [" + string3 + "]");
                continue;
            }
            state = new TextState();
            state.setName(string3);
            state.setItemCharacter(itemCharacter);
            itemCharacter.addState(state);
        }
        return itemCharacter;
    }

    private ItemCharacter parseFeatureDescription(String string, ItemCharacter itemCharacter) {
        int n = string.indexOf(". ");
        if (n == 0) {
            return itemCharacter;
        }
        int n2 = 1;
        while (string.charAt(n2) == ' ') {
            ++n2;
        }
        String string2 = "";
        try {
            string2 = string.substring(n2, n);
        }
        catch (Exception exception) {
            System.out.println("Not a valid character number: " + string2);
        }
        try {
            itemCharacter.setId(new Integer(string2));
        }
        catch (Exception exception) {
            System.out.println("Not a valid character number: " + string2);
        }
        int n3 = n + 1;
        int n4 = string.length();
        itemCharacter.setFeature(string.substring(n3, n4));
        return itemCharacter;
    }

    public MultiState parseMultiState(String string, String string2) {
        Integer n;
        int n2;
        if (string.length() == 0) {
            return null;
        }
        MultiState multiState = new MultiState();
        if (string2.equals("UM")) {
            multiState.setUnOrdered();
        } else {
            multiState.setOrdered();
        }
        for (n2 = 0; Character.isDigit(string.charAt(n2)) && n2 < string.length(); ++n2) {
        }
        String string3 = string.substring(0, n2);
        try {
            n = new Integer(string3);
        }
        catch (Exception exception) {
            n = new Integer(0);
            System.out.println(string3 + "not a valid ID in feature: " + string);
        }
        multiState.setId(n);
        String string4 = string.substring(++n2, string.length());
        multiState.setName(string4);
        return multiState;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length != 2) {
            System.out.println("Usage: CharsFileReader <chars file name> <specs file name>");
            System.exit(0);
        }
        SpecsFileReader specsFileReader = new SpecsFileReader();
        System.out.println("reading specs file...");
        specsFileReader.read(stringArray[1]);
        specsFileReader.makeItemCharacterTypes();
        System.out.println("done.");
        CharsFileReader charsFileReader = new CharsFileReader();
        charsFileReader.setItemCharacterTypes(specsFileReader.getItemCharacterTypes());
        System.out.println("reading chars file...");
        charsFileReader.read(stringArray[0], bl, bl2);
        charsFileReader.print();
    }
}

