/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.bo;

import java.util.StringTokenizer;
import java.util.Vector;
import net.metadiversity.diversity.navikey.bo.BasicState;
import net.metadiversity.diversity.navikey.bo.ItemCharacter;
import net.metadiversity.diversity.navikey.bo.State;
import net.metadiversity.diversity.navikey.delta.DeltaData;

public class NumericState
extends State {
    private boolean isReal;
    private boolean extremeUpperFlag;
    private boolean upperFlag;
    private boolean medianFlag;
    private boolean lowerFlag;
    private boolean extremeLowerFlag;
    private boolean initFlag;
    private double upper;
    private double lower;
    private double median;
    private double extremeUpper;
    private double extremeLower;

    public NumericState() {
        this.extremeUpperFlag = false;
        this.upperFlag = false;
        this.medianFlag = false;
        this.lowerFlag = false;
        this.extremeLowerFlag = false;
        this.initFlag = false;
    }

    public NumericState(BasicState basicState, DeltaData deltaData) {
        Comparable<Double> comparable;
        int n;
        this.setCharacterId(basicState.getCharacterId());
        this.setItemCharacter((ItemCharacter)deltaData.getItemCharacters().get(this.getCharacterId()));
        String string = basicState.getName();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c != '(' && c != ')' && c != '-' && c != '.' && !Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer.length() == 0) {
            return;
        }
        n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer.charAt(0) == '(') {
            ++n;
            while (stringBuffer.charAt(n) != ')' && n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (Character.isDigit(c) || c == '.') {
                    stringBuffer2.append(c);
                }
                ++n;
            }
        }
        if (stringBuffer2.length() > 0) {
            Double d = new Double(new String(stringBuffer2));
            this.setExtremeLower(d);
        }
        if (stringBuffer.charAt(n) == ')') {
            ++n;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        while (n < stringBuffer.length() && stringBuffer.charAt(n) != '(') {
            stringBuffer3.append(stringBuffer.charAt(n));
            ++n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(new String(stringBuffer3), "-");
        int n2 = 0;
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            ++n2;
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 1) {
            comparable = new Double((String)vector.elementAt(0));
            this.setMedian((Double)comparable);
        } else if (vector.size() == 2) {
            comparable = new Double((String)vector.elementAt(0));
            this.setLower((Double)comparable);
            comparable = new Double((String)vector.elementAt(1));
            this.setUpper((Double)comparable);
        } else if (vector.size() == 3) {
            comparable = new Double((String)vector.elementAt(0));
            this.setLower((Double)comparable);
            comparable = new Double((String)vector.elementAt(1));
            this.setMedian((Double)comparable);
            comparable = new Double((String)vector.elementAt(2));
            this.setUpper((Double)comparable);
        }
        comparable = new StringBuffer();
        while (n < stringBuffer.length() && stringBuffer.charAt(n) != ')') {
            char c = stringBuffer.charAt(n);
            if (Character.isDigit(c) || c == '.') {
                ((StringBuffer)comparable).append(c);
            }
            ++n;
        }
        if (((StringBuffer)comparable).length() > 0) {
            Double d = new Double(new String((StringBuffer)comparable));
            this.setExtremeUpper(d);
        }
    }

    @Override
    public boolean containedIn(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            NumericState numericState = (NumericState)vector.elementAt(i);
            if (!this.fallsWithinExtremeRange(numericState)) continue;
            return true;
        }
        return false;
    }

    public void initValues(double d) {
        this.initFlag = true;
        this.extremeLower = d;
        this.lower = d;
        this.median = d;
        this.upper = d;
        this.extremeUpper = d;
    }

    public void setLower(double d) {
        this.lowerFlag = true;
        if (!this.initFlag) {
            this.initValues(d);
            return;
        }
        this.lower = d;
        if (this.extremeLower > d) {
            this.extremeLower = d;
        }
        if (this.median < d) {
            this.median = d;
        }
        if (this.upper < d) {
            this.upper = d;
        }
        if (this.extremeUpper < d) {
            this.extremeUpper = d;
        }
    }

    public void setUpper(double d) {
        this.upperFlag = true;
        if (!this.initFlag) {
            this.initValues(d);
            return;
        }
        this.upper = d;
        if (this.lower > d) {
            this.lower = d;
        }
        if (this.median > d) {
            this.median = d;
        }
        if (this.extremeLower > d) {
            this.extremeLower = d;
        }
        if (this.extremeUpper < d) {
            this.extremeUpper = d;
        }
    }

    public void setMedian(double d) {
        this.medianFlag = true;
        if (!this.initFlag) {
            this.initValues(d);
            return;
        }
        this.median = d;
        if (this.lower > d) {
            this.lower = d;
        }
        if (this.extremeLower > d) {
            this.extremeLower = d;
        }
        if (this.upper < d) {
            this.upper = d;
        }
        if (this.extremeUpper < d) {
            this.extremeUpper = d;
        }
    }

    public void setExtremeLower(double d) {
        this.extremeLowerFlag = true;
        if (!this.initFlag) {
            this.initValues(d);
            return;
        }
        this.extremeLower = d;
        if (this.lower < d) {
            this.lower = d;
        }
        if (this.median < d) {
            this.median = d;
        }
        if (this.upper < d) {
            this.upper = d;
        }
        if (this.extremeUpper < d) {
            this.extremeUpper = d;
        }
    }

    public void setExtremeUpper(double d) {
        this.extremeUpperFlag = true;
        if (!this.initFlag) {
            this.initValues(d);
            return;
        }
        this.extremeUpper = d;
        if (this.extremeLower > d) {
            this.extremeLower = d;
        }
        if (this.lower > d) {
            this.lower = d;
        }
        if (this.median > d) {
            this.median = d;
        }
        if (this.upper > d) {
            this.upper = d;
        }
    }

    public double getMedian() {
        return this.median;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public double getExtremeLower() {
        return this.extremeLower;
    }

    public double getExtremeUpper() {
        return this.extremeUpper;
    }

    public void isReal(boolean bl) {
        this.isReal = bl;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public void isInteger(boolean bl) {
        this.isReal = !bl;
    }

    public boolean isInteger() {
        return !this.isReal;
    }

    public boolean fallsWithinNormalRange(NumericState numericState) {
        return numericState.getUpper() <= this.upper && numericState.getLower() >= this.lower;
    }

    public boolean overlappingNormalRange(NumericState numericState) {
        return numericState.getUpper() >= this.lower && numericState.getLower() <= this.upper;
    }

    public boolean fallsWithinExtremeRange(NumericState numericState) {
        return numericState.getUpper() <= this.extremeUpper && numericState.getLower() >= this.extremeLower;
    }

    public boolean overlappingExtremeRange(NumericState numericState) {
        return numericState.getUpper() >= this.extremeLower && numericState.getLower() <= this.extremeUpper;
    }

    @Override
    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (this.extremeLowerFlag) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(min) " + this.extremeLower);
        }
        if (this.lowerFlag) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(low) " + this.lower);
        }
        if (this.medianFlag) {
            stringBuffer.append("(median) " + this.median);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
        }
        if (this.upperFlag) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(high) " + this.upper);
        }
        if (this.extremeUpperFlag) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(max) " + this.extremeUpper);
        }
        return new String(stringBuffer);
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    private void printAll() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name: " + this.getName());
        stringBuffer.append(" extremeLower: " + this.extremeLowerFlag + " " + this.extremeLower);
        stringBuffer.append(" lower: " + this.lowerFlag + " " + this.lower);
        stringBuffer.append(" median: " + this.medianFlag + " " + this.median);
        stringBuffer.append(" upper: " + this.upperFlag + " " + this.upper);
        stringBuffer.append(" extremeUpper: " + this.extremeUpperFlag + this.extremeUpper);
        System.out.println(stringBuffer.toString());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name: " + this.getName());
        stringBuffer.append(this.getStringValue());
        return new String(stringBuffer);
    }

    public static void main(String[] stringArray) {
        NumericState numericState = new NumericState();
        numericState.setName("mm");
        numericState.setUpper(7.6);
        numericState.setMedian(5.0);
        numericState.setLower(4.2);
        numericState.printAll();
        System.out.println("-----");
        NumericState numericState2 = new NumericState();
        numericState2.setName("mm");
        numericState2.setUpper(8.6);
        numericState2.setLower(3.9);
        numericState2.printAll();
        System.out.println("-----");
        NumericState numericState3 = new NumericState();
        numericState3.setName("mm");
        numericState3.setExtremeUpper(-12.6);
        numericState3.printAll();
        System.out.println("-----");
        NumericState numericState4 = new NumericState();
        numericState4.setName("mm");
        numericState4.setExtremeLower(-18.6);
        numericState4.printAll();
        System.out.println("-----");
        if (numericState2.fallsWithinExtremeRange(numericState)) {
            System.out.println("ns2 falls within ns1");
        }
        if (numericState.fallsWithinExtremeRange(numericState2)) {
            System.out.println("ns1 falls within ns2");
        }
        System.out.println(numericState.getStringValue());
    }
}

