/*
 * Decompiled with CFR 0.152.
 */
package net.metadiversity.diversity.navikey.bo;

import java.util.Vector;
import net.metadiversity.diversity.navikey.bo.Attribute;
import net.metadiversity.diversity.navikey.bo.CommentedState;
import net.metadiversity.diversity.navikey.bo.NumericState;
import net.metadiversity.diversity.navikey.bo.State;
import net.metadiversity.diversity.navikey.ui.NaviKey;

public class NumericAttribute
extends Attribute {
    private Vector<CommentedState> commentedStates = new Vector();

    @Override
    public void addCommentedState(State state, String string) {
        this.commentedStates.addElement(new CommentedState(state, string));
    }

    @Override
    public Vector getCommentedStates() {
        return this.commentedStates;
    }

    @Override
    public Vector<State> getStates() {
        Vector<State> vector = new Vector<State>();
        for (int i = 0; i < this.commentedStates.size(); ++i) {
            vector.addElement(this.commentedStates.elementAt(i).getState());
        }
        return vector;
    }

    @Override
    public boolean containsState(State state) {
        Vector<State> vector = this.getStates();
        for (int i = 0; i < vector.size(); ++i) {
            State state2 = vector.elementAt(i);
            if (state != state2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sameAs(NaviKey naviKey, Attribute attribute) {
        boolean bl = false;
        Vector<State> vector = attribute.getStates();
        Vector<State> vector2 = this.getStates();
        block0: for (int i = 0; i < vector.size(); ++i) {
            bl = false;
            NumericState numericState = (NumericState)vector.elementAt(i);
            if (numericState == null) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                NumericState numericState2 = (NumericState)vector2.elementAt(j);
                if (naviKey.isExtremeInterval() && !naviKey.isOverlappingInterval() && numericState != null && numericState2 != null && numericState2.fallsWithinExtremeRange(numericState)) {
                    bl = true;
                    break block0;
                }
                if (!naviKey.isExtremeInterval() && !naviKey.isOverlappingInterval() && numericState != null && numericState2 != null && numericState2.fallsWithinNormalRange(numericState)) {
                    bl = true;
                    break block0;
                }
                if (naviKey.isExtremeInterval() && naviKey.isOverlappingInterval() && numericState != null && numericState2 != null && numericState2.overlappingExtremeRange(numericState)) {
                    bl = true;
                    break block0;
                }
                if (naviKey.isExtremeInterval() || !naviKey.isOverlappingInterval() || numericState == null || numericState2 == null || !numericState2.overlappingNormalRange(numericState)) continue;
                bl = true;
                break block0;
            }
        }
        return bl;
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ItemCharacter: " + this.ic.getId() + ". " + this.ic.getFeature());
        for (int i = 0; i < this.commentedStates.size(); ++i) {
            CommentedState commentedState = this.commentedStates.elementAt(i);
            NumericState numericState = (NumericState)commentedState.getState();
            String string = commentedState.getComment();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (numericState == null) continue;
            stringBuffer.append(numericState.toString());
        }
        if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        return new String(stringBuffer);
    }

    public String shortOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.commentedStates.size(); ++i) {
            if (i > 0) {
                stringBuffer.append("/");
            }
            CommentedState commentedState = this.commentedStates.elementAt(i);
            NumericState numericState = (NumericState)commentedState.getState();
            String string = commentedState.getComment();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (numericState == null) continue;
            stringBuffer.append(numericState.getStringValue());
        }
        if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        return new String(stringBuffer);
    }
}

